<?php
// qr.php - QRServer API (free, no GD needed)
$user_id = (int)($_GET['user_id'] ?? 0);
$scan_id = $_GET['scan_id'] ?? time();
$size = (int)($_GET['size'] ?? 10) * 20; // 200px default

if ($user_id <= 0) {
    http_response_code(400);
    exit;
}

$trackUrl = "https://test.nikosmoney.com/scan.php?user_id=$user_id&scan_id=$scan_id";
$apiUrl = "https://api.qrserver.com/v1/create-qr-code/?size={$size}x{$size}&data=" . urlencode($trackUrl);

header('Content-Type: image/png');
header('Cache-Control: no-cache'); // Fresh every time

$image = @file_get_contents($apiUrl);
echo $image ?: file_get_contents('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mP8/5+hHgAHggJ/PchI7wAAAABJRU5ErkJggg=='); // Tiny blank fallback
?>